/*
 * Decompiled with CFR 0.152.
 */
package calebe;

import calebe.model.Comunicador;
import calebe.model.Dispositivo;
import calebe.model.Funcoes;
import calebe.model.MyCallback;
import calebe.model.Sync;
import calebe.model.Update;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Principal
extends JFrame {
    public static int contador = 0;
    private static Principal principal;
    private JButton btLimpar;
    private JLabel id;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea2;
    private JTextField nome;
    private JLabel serial;
    private JLabel status;
    private JLabel statusSocket;
    private JTextArea txtLog;
    private JLabel versao;

    public Principal() {
        this.initComponents();
        principal = this;
        this.versao.setText("V." + String.valueOf(Update.getVersao()));
        Principal.statusSocket("");
        this.nome.setText(Sync.getNome());
        this.txtLog.setText("Carregando...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                Principal.this.index();
            }
        }).start();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtLog = new JTextArea();
        this.status = new JLabel();
        this.versao = new JLabel();
        this.serial = new JLabel();
        this.statusSocket = new JLabel();
        this.jLabel2 = new JLabel();
        this.nome = new JTextField();
        this.id = new JLabel();
        this.btLimpar = new JButton();
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.setBackground(new Color(255, 255, 255));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/calebe/calebe.jpg")));
        this.txtLog.setEditable(false);
        this.txtLog.setColumns(20);
        this.txtLog.setRows(5);
        this.jScrollPane1.setViewportView(this.txtLog);
        this.status.setText("...");
        this.versao.setText("versao");
        this.serial.setText("serial");
        this.statusSocket.setText("...");
        this.jLabel2.setText("Nome");
        this.nome.setText("Nome");
        this.nome.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                Principal.this.nomeFocusLost(evt);
            }
        });
        this.nome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Principal.this.nomeActionPerformed(evt);
            }
        });
        this.id.setText("id");
        this.btLimpar.setText("Limpar");
        this.btLimpar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Principal.this.btLimparActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.status, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versao, -2, 66, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(321, 321, 321).addComponent(this.btLimpar)).addComponent(this.nome).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.statusSocket, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.id, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serial, -2, 99, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 207, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.btLimpar)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nome, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serial).addComponent(this.statusSocket).addComponent(this.id)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.status).addComponent(this.versao))))));
        this.pack();
    }

    private void nomeActionPerformed(ActionEvent evt) {
    }

    private void nomeFocusLost(FocusEvent evt) {
        HashMap p = new HashMap(){
            {
                this.put("pacote", "sic7");
                this.put("class", "Dispositivo");
                this.put("metodo", "setNome");
                this.put("PK_maquina", Sync.getPK_maquina());
                this.put("nome", Principal.this.nome.getText().toString());
            }
        };
        MyCallback callback = new MyCallback(){

            @Override
            public void callbackCall(String s) {
                System.out.println(s);
                Sync.setNome(Principal.this.nome.getText().toString());
            }
        };
        Funcoes.post(p, callback);
    }

    private void btLimparActionPerformed(ActionEvent evt) {
        Principal.principal.txtLog.setText("");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Principal.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Principal.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Principal.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Principal.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Principal().setVisible(true);
            }
        });
    }

    private void index() {
        Principal.setSerial(Sync.getSerial());
        Principal.setID(Sync.getPK_maquina());
        HashMap<String, Object> disp = Dispositivo.getDados();
        System.out.println(Funcoes.hashMapToJson(disp));
        String text = "";
        text = text + "Sistema Operacional: " + disp.get("so").toString() + " " + disp.get("arch").toString();
        if (disp.get("CPU") != null) {
            text = text + "\nCPU: " + disp.get("CPU").toString();
        }
        if (disp.get("memoria") != null) {
            text = text + "\nMem\u00f3ria: " + disp.get("memoria").toString();
        }
        ArrayList disco = (ArrayList)disp.get("disco");
        for (int i = 0; i < disco.size(); ++i) {
            text = text + "\nDisco: " + ((HashMap)disco.get(i)).get("name").toString();
            text = text + " Total " + ((HashMap)disco.get(i)).get("total").toString();
            text = text + " Livre " + ((HashMap)disco.get(i)).get("livre").toString();
        }
        text = text + "\nIP Externo: " + disp.get("ipExterno").toString();
        text = text + "\nIP Interno: " + disp.get("ip").toString();
        text = text + "\nNome da M\u00e1quina: " + disp.get("host").toString();
        text = text + "\nUsu\u00e1rio: " + disp.get("usuario").toString() + " (" + disp.get("home").toString() + ")";
        text = text + "\nJava: " + disp.get("javav").toString() + "";
        text = text + "\nuser.dir: " + disp.get("user.dir").toString();
        if (disp.get("SN") != null) {
            text = text + "\nSN: " + disp.get("SN").toString();
        }
        this.txtLog.setText(text);
    }

    public static void setNotificacao(String notificacao) {
        if (principal != null && Principal.principal.status != null) {
            Principal.principal.status.setText(notificacao);
        }
    }

    public static void setStatus(String msg) {
        if (principal != null && Principal.principal.txtLog != null) {
            Principal.principal.txtLog.setText(Principal.principal.txtLog.getText() + "\n\n ----- " + Funcoes.getNow() + "\n" + msg);
            Principal.principal.txtLog.setCaretPosition(Principal.principal.txtLog.getDocument().getLength());
        }
    }

    public static void setSerial(String serial) {
        if (principal != null && Principal.principal.serial != null) {
            Principal.principal.serial.setText(serial);
        }
    }

    public static void setID(String id) {
        if (principal != null && Principal.principal.id != null) {
            Principal.principal.id.setText(id);
        }
    }

    public static void statusSocket(String msg) {
        if (principal != null && Principal.principal.statusSocket != null) {
            if (Comunicador.socket != null && Comunicador.socket.isConnected()) {
                Principal.principal.statusSocket.setText("Conectado " + msg);
                Principal.principal.statusSocket.setForeground(new Color(0, 150, 0));
            } else {
                Principal.principal.statusSocket.setText("Desconectado " + msg);
                Principal.principal.statusSocket.setForeground(new Color(100, 0, 0));
            }
        }
    }
}

