/*
 * Decompiled with CFR 0.152.
 */
package io.socket;

import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.IOConnection;
import io.socket.IOTransport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import org.json.JSONObject;

public class SocketIO {
    private IOCallback callback;
    private IOConnection connection;
    private String namespace;
    private Properties headers = new Properties();
    private URL url;

    public SocketIO() {
    }

    public SocketIO(String url) throws MalformedURLException {
        if (url == null) {
            throw new RuntimeException("url may not be null.");
        }
        this.setAndConnect(new URL(url), null);
    }

    public SocketIO(String url, Properties headers) throws MalformedURLException {
        if (url == null) {
            throw new RuntimeException("url may not be null.");
        }
        if (headers != null) {
            this.headers = headers;
        }
        this.setAndConnect(new URL(url), null);
    }

    public SocketIO(String url, IOCallback callback) throws MalformedURLException {
        this.connect(url, callback);
    }

    public SocketIO(URL url, IOCallback callback) {
        if (!this.setAndConnect(url, callback)) {
            throw new RuntimeException("url and callback may not be null.");
        }
    }

    public SocketIO(URL url) {
        this.setAndConnect(url, null);
    }

    public static void setDefaultSSLSocketFactory(SSLContext sslContext) {
        IOConnection.setSslContext(sslContext);
    }

    public void connect(String url, IOCallback callback) throws MalformedURLException {
        if (!this.setAndConnect(new URL(url), callback)) {
            if (url == null || callback == null) {
                throw new RuntimeException("url and callback may not be null.");
            }
            throw new RuntimeException("connect(String, IOCallback) can only be invoked after SocketIO()");
        }
    }

    public void connect(URL url, IOCallback callback) {
        if (!this.setAndConnect(url, callback)) {
            if (url == null || callback == null) {
                throw new RuntimeException("url and callback may not be null.");
            }
            throw new RuntimeException("connect(URL, IOCallback) can only be invoked after SocketIO()");
        }
    }

    public void connect(IOCallback callback) {
        if (!this.setAndConnect(null, callback)) {
            if (callback == null) {
                throw new RuntimeException("callback may not be null.");
            }
            if (this.url == null) {
                throw new RuntimeException("connect(IOCallback) can only be invoked after SocketIO(String) or SocketIO(URL)");
            }
        }
    }

    private boolean setAndConnect(URL url, IOCallback callback) {
        if (this.connection != null) {
            throw new RuntimeException("You can connect your SocketIO instance only once. Use a fresh instance instead.");
        }
        if (this.url != null && url != null || this.callback != null && callback != null) {
            return false;
        }
        if (url != null) {
            this.url = url;
        }
        if (callback != null) {
            this.callback = callback;
        }
        if (this.callback != null && this.url != null) {
            String origin = this.url.getProtocol() + "://" + this.url.getAuthority();
            this.namespace = this.url.getPath();
            if (this.namespace.equals("/")) {
                this.namespace = "";
            }
            this.connection = IOConnection.register(origin, this);
            return true;
        }
        return false;
    }

    public void emit(String event, Object ... args) {
        this.connection.emit(this, event, null, args);
    }

    public void emit(String event, IOAcknowledge ack, Object ... args) {
        this.connection.emit(this, event, ack, args);
    }

    public IOCallback getCallback() {
        return this.callback;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void send(JSONObject json) {
        this.connection.send(this, null, json);
    }

    public void send(IOAcknowledge ack, JSONObject json) {
        this.connection.send(this, ack, json);
    }

    public void send(String message) {
        this.connection.send(this, null, message);
    }

    public void send(IOAcknowledge ack, String message) {
        this.connection.send(this, ack, message);
    }

    public void disconnect() {
        this.connection.unregister(this);
    }

    public void reconnect() {
        this.connection.reconnect();
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    public String getTransport() {
        IOTransport transport = this.connection.getTransport();
        return transport != null ? transport.getName() : null;
    }

    public Properties getHeaders() {
        return this.headers;
    }

    void setHeaders(Properties headers) {
        this.headers = headers;
    }

    public SocketIO addHeader(String key, String value) {
        if (this.connection != null) {
            throw new RuntimeException("You may only set headers before connecting.\n Try to use new SocketIO().addHeader(key, value).connect(host, callback) instead of SocketIO(host, callback).addHeader(key, value)");
        }
        this.headers.setProperty(key, value);
        return this;
    }

    public String getHeader(String key) {
        if (this.headers.contains(key)) {
            return this.headers.getProperty(key);
        }
        return null;
    }
}

