/*
 * Decompiled with CFR 0.152.
 */
package calebe;

import calebe.Principal;
import calebe.model.Comunicador;
import calebe.model.Funcoes;
import calebe.model.Sync;
import calebe.model.Update;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Calebe {
    public static Comunicador c = null;
    private static TrayIcon trayIcon = null;

    public static void main(String[] args) {
        String caminho = "";
        try {
            caminho = Calebe.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            caminho = caminho.substring(1, caminho.lastIndexOf(47) + 1);
            if (Funcoes.isMAC()) {
                caminho = "/" + caminho;
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (args.length > 0 && args[0].equals("update")) {
            try {
                String origem = caminho;
                String destino = caminho.substring(0, caminho.length() - 7);
                System.out.println("Copiando " + origem + " para " + destino + "");
                Funcoes.copyDirectoryCompatibityMode(origem, destino);
                System.out.println("Copiado!");
                try {
                    StringBuilder cmd = new StringBuilder();
                    cmd.append("\"").append(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java").append("\" ");
                    for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                        cmd.append(jvmArg + " ");
                    }
                    cmd.append("-jar ").append("\"").append(destino).append("Calebe.jar").append("\"");
                    System.out.println("Iniciando Calebe: " + cmd.toString());
                    Runtime.getRuntime().exec(cmd.toString());
                }
                catch (IOException ex) {
                    Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.exit(0);
        }
        Funcoes.remover(new File(caminho + "Calebe.zip"));
        Funcoes.remover(new File(caminho + "UPDATE"));
        Calebe.SystemTrayIcon();
        if (Funcoes.isMAC()) {
            new Principal().show();
        }
        c = new Comunicador();
        c.conectar();
        new Sync().sync();
        System.out.println("Calebe!");
    }

    public static void restart() {
        if (trayIcon != null) {
            if (SystemTray.isSupported()) {
                SystemTray tray = SystemTray.getSystemTray();
                tray.remove(trayIcon);
            }
            trayIcon = null;
        }
        try {
            StringBuilder cmd = new StringBuilder();
            cmd.append(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java ");
            for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                cmd.append(jvmArg + " ");
            }
            cmd.append("-cp ").append(ManagementFactory.getRuntimeMXBean().getClassPath()).append(" ");
            cmd.append(Calebe.class.getName()).append(" ");
            Runtime.getRuntime().exec(cmd.toString());
        }
        catch (IOException ex) {
            Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.exit(0);
    }

    public static void SystemTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            String caminho = "";
            try {
                caminho = Calebe.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                caminho = caminho.substring(1, caminho.lastIndexOf(47) + 1);
                if (Funcoes.isMAC()) {
                    caminho = "/" + caminho;
                }
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
            }
            caminho = caminho + "calebe.jpg";
            Image image = Toolkit.getDefaultToolkit().getImage(Calebe.class.getResource("/img/calebe.png"));
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Principal().show();
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Principal");
            defaultItem.addActionListener(listener);
            popup.add(defaultItem);
            MenuItem update = new MenuItem("Atualizar");
            update.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Principal.setStatus("Baixando nova vers\u00e3o");
                    new Update().update();
                }
            });
            popup.add(update);
            MenuItem reiniciar = new MenuItem("Reiniciar");
            reiniciar.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String caminho = "";
                    try {
                        caminho = Calebe.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                        if (!Funcoes.isMAC()) {
                            caminho = caminho.substring(1, caminho.length());
                        }
                    }
                    catch (URISyntaxException ex) {
                        Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    try {
                        StringBuilder cmd = new StringBuilder();
                        if (Funcoes.isMAC()) {
                            cmd.append("java").append(" ");
                        } else {
                            cmd.append("\"").append(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java").append("\" ");
                        }
                        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                            cmd.append(jvmArg + " ");
                        }
                        cmd.append("-jar ").append("\"").append(caminho).append("\"").append(" &");
                        System.out.println("Reiniciando Calebe: " + cmd.toString());
                        Runtime.getRuntime().exec(cmd.toString());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Calebe.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    System.exit(0);
                }
            });
            popup.add(reiniciar);
            MenuItem manterImpressao = new MenuItem("Manter impress\u00e3o com erro");
            manterImpressao.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.setManterImpressaoErro(true);
                }
            });
            popup.add(manterImpressao);
            MenuItem bt = new MenuItem("Iniciar com Windows");
            bt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.iniciarComSistema("add");
                }
            });
            popup.add(bt);
            bt = new MenuItem("N\u00e3o iniciar com Windows");
            bt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.iniciarComSistema("delete");
                }
            });
            popup.add(bt);
            MenuItem sair = new MenuItem("Sair");
            sair.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
            popup.add(sair);
            trayIcon = new TrayIcon(image, "Calebe", popup);
            trayIcon.addActionListener(listener);
            try {
                tray.add(trayIcon);
            }
            catch (AWTException e) {
                System.err.println(e);
            }
            System.out.println("System Tray Icon OK!");
        } else {
            System.out.println("N\u00e3o h\u00e1 suporte para System Tray Icon");
        }
    }
}

