/*
 * Decompiled with CFR 0.152.
 */
package calebe.model;

import calebe.Calebe;
import calebe.Impressora;
import calebe.Principal;
import calebe.model.Funcoes;
import calebe.model.GoodWindowsExec;
import calebe.model.MyCallback;
import calebe.model.Robo;
import calebe.model.Sync;
import calebe.model.Update;
import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.SocketIO;
import io.socket.SocketIOException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Comunicador {
    public static SocketIO socket;
    static IOCallback callback;
    private static Thread proc;
    Thread _conectar_ = null;
    Calendar ultimaConexao = Calendar.getInstance();

    public Comunicador() {
        this.ultimaConexao.set(2000, 1, 1);
        callback = new IOCallback(){

            @Override
            public void onMessage(JSONObject json, IOAcknowledge ack) {
                try {
                    System.out.println("onMessage json:" + json.toString(2));
                    Principal.setNotificacao("onMessage json:" + json.toString(2));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onMessage(String data, IOAcknowledge ack) {
                System.out.println("onMessage data: " + data);
                Principal.setNotificacao("onMessage data: " + data);
            }

            @Override
            public void onError(SocketIOException socketIOException) {
                System.out.println("onError: " + socketIOException.getMessage());
                Principal.statusSocket("onError: " + socketIOException.getMessage());
                Comunicador.this.conectar();
            }

            @Override
            public void onDisconnect() {
                System.out.println("onDisconnect");
                Principal.statusSocket("onDisconnect");
                Comunicador.this.conectar();
            }

            @Override
            public void onConnect() {
                System.out.println("onConnect");
                Principal.statusSocket("onConnect");
            }

            @Override
            public void on(String event, IOAcknowledge ack, Object ... args) {
                System.out.println("on: " + event);
                Principal.statusSocket("");
                if (event.equals("dados")) {
                    Comunicador.this.recebeDados(args[0].toString());
                }
            }
        };
        this.verifica();
    }

    public void conectar() {
        this.conectar(false);
    }

    public void conectar(boolean forcar) {
        Calendar data2 = Calendar.getInstance();
        long diferenca = data2.getTimeInMillis() - this.ultimaConexao.getTimeInMillis();
        if (diferenca > 10000L || forcar) {
            this.ultimaConexao = data2;
            this.desconectar();
            try {
                socket = new SocketIO(Funcoes.getConfig("urlSocket").toString());
                socket.connect(callback);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (!this.isConnected()) {
            if (this._conectar_ != null && this._conectar_.isAlive()) {
                this._conectar_.interrupt();
                this._conectar_ = null;
            }
            this._conectar_ = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                        Comunicador.this.conectar();
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            this._conectar_.start();
        }
    }

    public void desconectar() {
        if (socket != null) {
            if (socket.isConnected()) {
                socket.disconnect();
            }
            socket = null;
        }
    }

    private void recebeDados(String _dados) {
        System.out.println("recebeDados: " + _dados);
        final HashMap<String, Object> dados = Funcoes.jsonToHashMap(_dados);
        if (dados.get("serial") != null && (dados.get("serial").toString().equals("TODOS") || dados.get("serial").toString().equals(Sync.getSerial())) || dados.get("id") != null && (dados.get("id").toString().equals("TODOS") || dados.get("id").toString().equals(Sync.getPK_maquina()))) {
            if (!String.valueOf(dados.get("id")).equals("null")) {
                System.out.println("ID [" + dados.get("id") + "] COMANDO RECEBIDO ");
            } else if (!String.valueOf(dados.get("serial")).equals("null")) {
                System.out.println("SERIAL [" + dados.get("serial") + "] COMANDO RECEBIDO ");
            }
            if (dados.get("metodo") != null) {
                Principal.setNotificacao("recebeDados: " + dados.get("metodo"));
                String metodo = dados.get("metodo").toString();
                Principal.setNotificacao("metodo: " + metodo);
                if (metodo.equals("isOnline")) {
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("online", "1");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                } else if (metodo.equals("sync")) {
                    new Sync().sync();
                } else if (metodo.equals("update")) {
                    Principal.setStatus("Atualizando...");
                    new Update().update();
                } else if (metodo.equals("restart")) {
                    Calebe.restart();
                } else if (metodo.equals("command")) {
                    String command = dados.get("command").toString();
                    String retCommand = Funcoes.command(command);
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("ret", retCommand);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                } else if (metodo.equals("getImpressoras")) {
                    List<String> impressoas = Impressora.getImpressoras();
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("impressoras", impressoas);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                    String txtStatus = "Impressoras: \n";
                    for (int i = 0; i < impressoas.size(); ++i) {
                        txtStatus = txtStatus + impressoas.get(i) + "\n";
                    }
                    Principal.setStatus(txtStatus);
                } else if (metodo.equals("imprimirPDF")) {
                    this.imprimirPDF(dados);
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("msg", "Documento PDF impresso");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                } else if (metodo.equals("zpl")) {
                    this.imprimirZPL(dados);
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("msg", "Documento ZPL impresso");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                    Principal.setStatus("Documento ZPL impresso");
                } else if (metodo.equals("download")) {
                    String url = Funcoes.getValor(dados, "url");
                    Principal.setStatus("Baixando: " + url);
                    String pathname = Funcoes.getValor(dados, "nome", Funcoes.uniqueName() + "_" + ++Principal.contador + ".pdf");
                    Funcoes.download(url, pathname);
                    Principal.setStatus("Documento baixado!");
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("msg", "Documento baixado");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                } else if (metodo.equals("getArquivoTempo")) {
                    Thread lendo = null;
                    if (lendo != null) {
                        Principal.setStatus("STOP loop getArquivoTempo");
                        if (lendo.isAlive()) {
                            lendo.interrupt();
                            lendo = null;
                        }
                    }
                    lendo = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            final String arquivo = Funcoes.getValor(dados, "arquivo");
                            int tempo = Funcoes.parseInt(Funcoes.getValor(dados, "tempo", "1"));
                            boolean delete = Funcoes.parseBool(Funcoes.getValor(dados, "delete", "0"));
                            Funcoes.emit(new HashMap(){
                                {
                                    this.put("id", Sync.getPK_maquina());
                                    this.put("serial", Sync.getSerial());
                                    this.put("arquivo", arquivo);
                                    this.put("msg", "Aguardando arquivo");
                                }
                            });
                            Principal.setStatus("Ler arquivo: " + arquivo + " --- tempo: " + tempo + "s");
                            if (!arquivo.equals("")) {
                                final String str = Funcoes.getArquivoTempo(arquivo, tempo);
                                Principal.setStatus("Arquivo: " + str);
                                JSONObject json = new JSONObject();
                                try {
                                    json.put("id", Sync.getPK_maquina());
                                    json.put("serial", Sync.getSerial());
                                    json.put("arquivo", arquivo);
                                    if (str.equals("-3")) {
                                        json.put("msg", "Exception: Erro na leitura do arquivo");
                                    } else if (str.equals("-2")) {
                                        json.put("msg", "Arquivo n\u00e3o encontrado");
                                    } else if (str.equals("-1")) {
                                        json.put("msg", "-1");
                                    } else {
                                        json.put("data", str);
                                    }
                                }
                                catch (JSONException ex) {
                                    Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                socket.emit("dados", json);
                                HashMap p = new HashMap(){
                                    {
                                        this.put("sistema", Funcoes.getValor(dados, "sistema"));
                                        this.put("chave", Funcoes.getValor(dados, "chave"));
                                        this.put("pacote", "comercial");
                                        this.put("class", "TEF");
                                        this.put("metodo", "setTEF");
                                        this.put("arquivo", arquivo);
                                        this.put("data", str);
                                        this.put("id", Sync.getPK_maquina());
                                    }
                                };
                                MyCallback callback = new MyCallback(){

                                    @Override
                                    public void callbackCall(String s) {
                                        Principal.setStatus("Enviado para o servidor: " + s);
                                    }
                                };
                                Funcoes.post(p, callback);
                                if (delete) {
                                    Funcoes.deletarArquivo(arquivo);
                                }
                            }
                        }
                    });
                    lendo.start();
                } else if (metodo.equals("setArquivo")) {
                    String arquivo = Funcoes.getValor(dados, "arquivo");
                    String data = Funcoes.getValor(dados, "data");
                    Principal.setStatus("Criar arquivo: " + arquivo + "\n" + data + "");
                    Funcoes.file_put_contents(arquivo, data);
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("msg", "Arquivo gerado");
                        json.put("arquivo", arquivo);
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                } else if (metodo.equals("deleteArquivo")) {
                    String arquivo = Funcoes.getValor(dados, "arquivo");
                    Principal.setStatus("Deletar arquivo: " + arquivo);
                    Funcoes.deletarArquivo(arquivo);
                    JSONObject json = new JSONObject();
                    try {
                        json.put("id", Sync.getPK_maquina());
                        json.put("serial", Sync.getSerial());
                        json.put("msg", "Arquivo deletado");
                    }
                    catch (JSONException ex) {
                        Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    socket.emit("dados", json);
                } else if (metodo.equals("setaDireita")) {
                    new Robo().setaDireita();
                    Principal.setStatus("Seta direita ->");
                } else if (metodo.equals("setaEsquerda")) {
                    new Robo().setaEsquerda();
                    Principal.setStatus("Seta esquerda ->");
                }
            }
        }
    }

    private void imprimirPDF(HashMap<String, Object> dados) {
        boolean delete;
        String impressora = Funcoes.getValor(dados, "impressora");
        String url = Funcoes.getValor(dados, "url");
        String orientation = Funcoes.getValor(dados, "orientation");
        int width = Integer.parseInt(Funcoes.getValor(dados, "width", "0"));
        int height = Integer.parseInt(Funcoes.getValor(dados, "height", "0"));
        int copias = Funcoes.parseInt(Funcoes.getValor(dados, "copias", "1"));
        Principal.setStatus(url + "\nEnviando para " + impressora + " copias: " + copias);
        if (width != 0 || height != 0) {
            Principal.setStatus("Largura: " + width + " Altura: " + height);
        }
        String pathname = Funcoes.uniqueName() + "_" + ++Principal.contador + ".pdf";
        Principal.setStatus("Baixando PDF...");
        Funcoes.getURL(url, pathname);
        Principal.setStatus("PDF OK");
        Impressora imp = new Impressora();
        boolean bl = delete = copias == 1;
        if (copias == 1) {
            imp.printPdf(impressora, pathname, delete, orientation, width, height);
        } else {
            delete = false;
            for (int i = 0; i < copias; ++i) {
                if (copias == i + 1) {
                    delete = true;
                }
                imp.printPdf(impressora, pathname, delete, orientation);
            }
        }
    }

    private void imprimirZPL(HashMap<String, Object> dados) {
        String impressora = Funcoes.getValor(dados, "impressora");
        String texto = Funcoes.getValor(dados, "texto");
        texto = Funcoes.base64decode(dados.get("texto").toString());
        Principal.setStatus(texto + "\nEnviando para " + impressora);
        Funcoes.deletarArquivo("arquivo.prn");
        Funcoes.file_put_contents("arquivo.prn", texto);
        String command = "";
        command = System.getProperty("os.name").equals("Mac OS X") ? "lp -d " + impressora + " arquivo.prn" : "copy /B arquivo.prn \\\\localhost\\" + impressora;
        Principal.setStatus("Comando de Impress\u00e3o: " + command);
        GoodWindowsExec.main(new String[]{command});
    }

    private void imprimirZPL_direct(HashMap<String, Object> dados) {
        String impressora = Funcoes.getValor(dados, "impressora");
        String texto = Funcoes.getValor(dados, "texto");
        texto = Funcoes.base64decode(dados.get("texto").toString());
        Principal.setStatus(texto + "\nEnviando para " + impressora);
        try {
            FileOutputStream os = new FileOutputStream(impressora);
            PrintStream ps = new PrintStream(os);
            ps.println(texto);
            ps.close();
            os.close();
            Principal.setStatus("Etiqueta impressa");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
            Principal.setStatus("Falha na impress\u00e3o: " + ex.getMessage());
        }
        catch (IOException ex) {
            Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
            Principal.setStatus("Falha na impress\u00e3o: " + ex.getMessage());
        }
    }

    private void verifica() {
        if (proc != null && proc.isAlive()) {
            proc.interrupt();
            proc = null;
        }
        proc = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                    if (socket != null && socket.isConnected()) {
                        socket.emit("ping", "teste");
                        socket.send("TESTE");
                    } else {
                        Comunicador.this.conectar();
                    }
                    Comunicador.this.verifica();
                }
                catch (InterruptedException ex) {
                    Comunicador.this.conectar();
                    Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        proc.start();
    }

    private boolean isConnected() {
        return socket.isConnected();
    }

    static {
        proc = null;
    }
}

